* Ricker_polynomial.sas;
title "Polynomial regression for Ricker data";
data ricker;
	input n logR;
	* For centered polynomials, you'll need the mean X value;
	nbar = 50.455;
	x = n-nbar;
	x2 = x**2;
	x3 = x**3;
	datalines;
 5  0.42
10  0.33
20  0.48
30  0.03
40 -0.18
50 -0.16
60  0.08
70 -1.20
80 -1.45
90 -1.72
100 -2.67
;
run;
* Print data set;
proc print data=ricker;
run;
* Plot data and fit smooth line;
proc gplot data=ricker;
	plot logR*n / vaxis=axis1 haxis=axis1;
	symbol1 i=sm70 v=star c=black height=2 width=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Polynomial regression;
proc glm data=ricker;
	* Look at Type I tests to determine order of polynomial;
	model logR = x x2 x3;
run;
* Preceding analysis suggests second-order polynomial adequate;
* Plot the data and second-order polynomial;
proc gplot data=ricker;
	plot logR*n / vaxis=axis1 haxis=axis1;
	symbol1 i=rqclm v=star c=black height=2 width=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Polynomial regression with second-order polynomial;
proc reg data=ricker;
	model logR = x x2 / clb stb tol vif partial;
run;
quit;